/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.i18n.util.GDKOracleMetaData;

public class OraBoot
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static OraBoot upCache = null;
    private static final String FILENAME = GDKOracleMetaData.getDataPath() + "lx0boot.glb";
    protected HashMap languageIdMap = null;
    protected HashMap territoryIdMap = null;
    protected HashMap linguisticIdMap = null;
    protected HashMap charSetIdMap = null;
    protected HashMap tableIdMap = null;
    protected HashMap idtoLanguageMap = null;
    protected HashMap idtoTerritoryMap = null;
    protected HashMap idtoCharSetMap = null;
    protected HashMap idtoLinguisticMap = null;
    protected HashMap idtoTableMap = null;
    protected HashMap oraShortToOraLangMap = null;
    protected Map oraLangToOraShortMap = null;
    protected Map idtoCharSetMaxLen = null;
    protected Map langToTerrMap = null;
    protected Map langToLingMap = null;
    protected Map langToCharSetsUnix = null;
    protected Map langToCharSetsWin = null;
    protected List lstCharSetIsAscii;
    protected List lstCharSetIsEbcdic;
    protected List lstCharSetIsFixed;
    protected List lstCharSetIsStorage;
    protected String[] availableLang = null;
    protected String[] availableTerr = null;
    protected String[] availableCharSet = null;
    protected String[] availableLing = null;
    static /* synthetic */ Class class$oracle$i18n$text$OraBoot;

    protected OraBoot() {
    }

    public static synchronized OraBoot getInstance() {
        if (upCache == null) {
            upCache = (OraBoot)OraBoot.readObj(FILENAME);
        }
        return upCache;
    }

    public String getLanguageFileName(String string) {
        return (String)this.languageIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string) {
        return (String)this.territoryIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerritoryFileName(String string, String string2) {
        if (string == null) {
            return (String)this.territoryIdMap.get(string2.toUpperCase(Locale.US));
        }
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = (String)this.territoryIdMap.get(string3 + "_" + string4);
        if (string5 != null) {
            return string5;
        }
        return (String)this.territoryIdMap.get(string4);
    }

    public String getLinguisticFileName(String string) {
        return (String)this.linguisticIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetFileName(String string) {
        return OraBoot.formatFileName("lx2", (String)this.charSetIdMap.get(string.toUpperCase(Locale.US)));
    }

    public String getTableFileName(String string) {
        return (String)this.tableIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getCharSetId(String string) {
        return (String)this.charSetIdMap.get(string.toUpperCase(Locale.US));
    }

    public String getLanguageName(String string) {
        return (String)this.idtoLanguageMap.get(string);
    }

    public String getTerritoryName(String string) {
        return (String)this.idtoTerritoryMap.get(string);
    }

    public String getCharSetName(String string) {
        return (String)this.idtoCharSetMap.get(string);
    }

    public String getLinguisticName(String string) {
        return (String)this.idtoLinguisticMap.get(string);
    }

    public String getTableName(String string) {
        return (String)this.idtoTableMap.get(string);
    }

    public String getOraLangFromShort(String string) {
        return (String)this.oraShortToOraLangMap.get(string.toUpperCase(Locale.US));
    }

    public String getOraShortFromLang(String string) {
        return (String)this.oraLangToOraShortMap.get(string.toUpperCase(Locale.US));
    }

    public String getTerrIdFromLang(String string) {
        return (String)this.langToTerrMap.get(string.toUpperCase(Locale.US));
    }

    public String getLingFromLang(String string) {
        return (String)this.langToLingMap.get(string.toUpperCase(Locale.US));
    }

    public List getLocalCharsetsWin(String string) {
        return (List)this.langToCharSetsWin.get(string.toUpperCase(Locale.US));
    }

    public List getLocalCharsetsUnix(String string) {
        return (List)this.langToCharSetsUnix.get(string.toUpperCase(Locale.US));
    }

    public String getCharsetMaxCharLen(String string) {
        return (String)this.idtoCharSetMaxLen.get(string);
    }

    public List getCharSetIsAscii() {
        return this.lstCharSetIsAscii;
    }

    public List getCharSetIsEbcdic() {
        return this.lstCharSetIsEbcdic;
    }

    public List getCharSetIsFixed() {
        return this.lstCharSetIsFixed;
    }

    public List getCharSetIsStorage() {
        return this.lstCharSetIsStorage;
    }

    public String[] availableLanguages() {
        return this.availableLang;
    }

    public String[] availableTerritories() {
        return this.availableTerr;
    }

    public String[] availableCharacterSets() {
        return this.availableCharSet;
    }

    public String[] availableLinguisticSorts() {
        return this.availableLing;
    }

    protected static String formatFileName(String string, String string2) {
        String string3 = "0000";
        String string4 = Integer.toHexString(Integer.parseInt(string2));
        String string5 = string3.substring(0, string3.length() - string4.length()) + string4;
        return string + string5;
    }

    static Object readObj(String string) {
        Class clazz = class$oracle$i18n$text$OraBoot == null ? (class$oracle$i18n$text$OraBoot = OraBoot.class$("oracle.i18n.text.OraBoot")) : class$oracle$i18n$text$OraBoot;
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException: " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("ClassNotFound: " + classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

